!Object constantsFor: 'Geos Libraries'!

geosLIB17 'SYSTEM\contlog'! !

!Object constantsFor: 'Geos vardata'!

attrLogControlNotifyEntrySelectedMsg 28160!
attrRecentContactsControlNotifyEntrySelectedMsg 28160!
tempRecentContactsControlConfirmDialog 28164!
attrRecentContactsControlNotifyMultipleEntriesSelectedMsg 28168!
attrRecentContactsPhoneControlNotifyMissedCallsListOpenedMsg 28672!
!

!Object constantsFor: 'Geos messages'!

genControlListEntryQuery 27648!
genControlSetFieldSpacing 27649!
genControlDrawListMoniker 27650!
genControlSetListVisibility 27651!
genControlDrawFieldLines 27652!
lengthControlInitiateDialog 27648!
lengthControlListItemSelected 27649!
controlAffirmDelete 28160!
controlDisplayLog 28161!
controlViewEventsSearchSubset 28162!
controlTrimLog 28163!
controlSelectionChanged 28164!
controlSelectCurrentEntry 28165!
contactsControlDisplayLog 28160!
contactsControlPersonContactsSearchSubset 28161!
contactsControlPersonContactsAffirmDelete 28162!
contactsControlRetrieveList 28160!
contactsControlOpenList 28161!
contactsControlListQuery 28162!
contactsControlClearAll 28163!
contactsControlSelectCurrentEntry 28164!
contactsControlEraseStack 28165!
contactsControlEraseStackCanceled 28166!
contactsControlCopyNumber 28167!
contactsControlClearAllLists 28168!
contactsControlClearAllListsOk 28169!
contactsControlSelectionChanged 28170!
contactsControlOpenGivenList 28171!
contactsControlCreateCard 28172!
!

!Geos class methodsFor: 'library calls'!

LogAddEntry: logEntry
	"Boolean pascal LogAddEntry(LogEntry *logEntry) in contlog.goh"
	^GEOS call: logEntry with: #[17 0 17 3 4]!

LogDeleteAllEntries
	"void pascal LogDeleteAllEntries() in contlog.goh"
	^GEOS call: #[17 0 18 0]!

LogDestroy
	"void pascal LogDestroy() in contlog.goh"
	^GEOS call: #[17 0 19 0]!

RecentContactsGetCount: rcType
	"word pascal RecentContactsGetCount(RecentContactsType rcType) in contlog.goh"
	^GEOS call: rcType with: #[17 0 20 1 1]!

RecentContactsGetEntry: rcType with: item with: buffer
	"word pascal RecentContactsGetEntry(RecentContactsType rcType, int item, LogEntry *buffer) in contlog.goh"
	^GEOS call: rcType with: item with: buffer with: #[17 0 21 1 4 3 1]!

RecentContactsGetNewCount: rcType
	"word pascal RecentContactsGetNewCount(RecentContactsType rcType) in contlog.goh"
	^GEOS call: rcType with: #[17 0 22 1 1]!

RecentContactsResetNewCount: rcType
	"void pascal RecentContactsResetNewCount(RecentContactsType rcType) in contlog.goh"
	^GEOS call: rcType with: #[17 0 23 1 0]!

RecentContactsEraseStack: rcType
	"Boolean pascal RecentContactsEraseStack(RecentContactsType rcType) in contlog.goh"
	^GEOS call: rcType with: #[17 0 25 1 4]!

RecentContactsResetMissedCallsTotalCount
	"void pascal RecentContactsResetMissedCallsTotalCount() in contlog.goh"
	^GEOS call: #[17 0 26 0]!

RecentContactsGetMissedCallsTotalCount
	"int pascal RecentContactsGetMissedCallsTotalCount() in contlog.goh"
	^GEOS call: #[17 0 27 4]!

LogGetCount
	"word pascal LogGetCount() in contlog.goh"
	^GEOS call: #[17 0 30 1]!

LogGetEntry: item with: buffer
	"Boolean pascal LogGetEntry(int item, LogEntry *buffer) in contlog.goh"
	^GEOS call: item with: buffer with: #[17 0 31 4 3 4]!

LogFindMatchingType: lft with: logEntry with: hugeArray
	"Boolean pascal LogFindMatchingType(word lft, optr logEntry, VMBlockHandle hugeArray) in contlog.goh"
	^GEOS call: lft with: logEntry with: hugeArray with: #[17 0 34 1 2 1 4]!

LogDeleteMatchingType: lft with: logEntry
	"Boolean pascal LogDeleteMatchingType(LogFieldType lft, optr logEntry) in contlog.goh"
	^GEOS call: lft with: logEntry with: #[17 0 35 1 2 4]!

!

GenControl subclass: #LogGenControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #LogLengthControl
	instanceVariableNames: ''
	classVariableNames: ''!

LogGenControl subclass: #LogControl
	instanceVariableNames: ''
	classVariableNames: ''!

LogGenControl subclass: #PersonContactsControl
	instanceVariableNames: ''
	classVariableNames: ''!

LogGenControl subclass: #RecentContactsControl
	instanceVariableNames: ''
	classVariableNames: ''!

RecentContactsControl subclass: #RecentContactsFaxControl
	instanceVariableNames: ''
	classVariableNames: ''!

RecentContactsControl subclass: #RecentContactsPhoneControl
	instanceVariableNames: ''
	classVariableNames: ''!

RecentContactsControl subclass: #RecentContactsSMSControl
	instanceVariableNames: ''
	classVariableNames: ''!

!LogGenControl comment!
Library contlog, file contlog.goh! !

!LogGenControl class methodsFor: 'library linkage'!

library
	^17!

entry
	^3!
!

!LogGenControl methodsFor: 'Geos instance variables'!

lgciHugeArrayHandle
	"@instance word LGCI_hugeArrayHandle"
	^self wordAt: 25!

lgciHugeArrayHandle: value
	"@instance word LGCI_hugeArrayHandle"
	^self wordAt: 25 put: value!

lgciListType
	"@instance byte LGCI_listType"
	^self byteAt: 27!

lgciListType: value
	"@instance byte LGCI_listType"
	^self byteAt: 27 put: value!

lgciSpacingSet
	"@instance byte LGCI_spacingSet"
	^self byteAt: 28!

lgciSpacingSet: value
	"@instance byte LGCI_spacingSet"
	^self byteAt: 28 put: value!

lgciNameNumberLineOffset
	"@instance word LGCI_nameNumberLineOffset"
	^self wordAt: 29!

lgciNameNumberLineOffset: value
	"@instance word LGCI_nameNumberLineOffset"
	^self wordAt: 29 put: value!

lgciTypeLineOffset
	"@instance word LGCI_typeLineOffset"
	^self wordAt: 31!

lgciTypeLineOffset: value
	"@instance word LGCI_typeLineOffset"
	^self wordAt: 31 put: value!

lgciDirectionLineOffset
	"@instance word LGCI_directionLineOffset"
	^self wordAt: 33!

lgciDirectionLineOffset: value
	"@instance word LGCI_directionLineOffset"
	^self wordAt: 33 put: value!

lgciDatetimeLineOffset
	"@instance word LGCI_datetimeLineOffset"
	^self wordAt: 35!

lgciDatetimeLineOffset: value
	"@instance word LGCI_datetimeLineOffset"
	^self wordAt: 35 put: value!

lgciDurationLineOffset
	"@instance word LGCI_durationLineOffset"
	^self wordAt: 37!

lgciDurationLineOffset: value
	"@instance word LGCI_durationLineOffset"
	^self wordAt: 37 put: value!

!

!LogGenControl methodsFor: 'Geos vardata'!

!

!LogGenControl methodsFor: 'Geos messages'!

genControlListEntryQuery
	"@message void MSG_LOG_GEN_CONTROL_LIST_ENTRY_QUERY()"
	^self geosMessage: #[108 0 2 0 0]!

genControlSetFieldSpacing
	"@message void MSG_LOG_GEN_CONTROL_SET_FIELD_SPACING()"
	^self geosMessage: #[108 1 2 0 0]!

genControlDrawListMoniker: list
	"@message void MSG_LOG_GEN_CONTROL_DRAW_LIST_MONIKER(optr list = cx:dx)"
	^self geosMessage: #[108 2 2 53 2 0] with: list!

genControlSetListVisibility: status
	"@message void MSG_LOG_GEN_CONTROL_SET_LIST_VISIBILITY( ListVisibilityStatus status = cx)"
	^self geosMessage: #[108 3 2 5 1 0] with: status!

genControlDrawFieldLines: gstate with: top with: bottom
	"@message void MSG_LOG_GEN_CONTROL_DRAW_FIELD_LINES(GStateHandle gstate = cx, int top = bp, int bottom = dx)"
	^self geosMessage: #[108 4 3 189 1 4 4 0] with: gstate with: top with: bottom!

!

!LogLengthControl comment!
Library contlog, file contlog.goh! !

!LogLengthControl class methodsFor: 'library linkage'!

library
	^17!

entry
	^9!
!

!LogLengthControl methodsFor: 'Geos instance variables'!

llciDialogs
	"@instance optr LLCI_dialogs"
	^self dwordAt: 25!

llciDialogs: value
	"@instance optr LLCI_dialogs"
	^self dwordAt: 25 put: value!

!

!LogLengthControl methodsFor: 'Geos vardata'!

!

!LogLengthControl methodsFor: 'Geos messages'!

lengthControlInitiateDialog
	"@message void MSG_LOG_LENGTH_CONTROL_INITIATE_DIALOG()"
	^self geosMessage: #[108 0 2 0 0]!

lengthControlListItemSelected
	"@message void MSG_LOG_LENGTH_CONTROL_LIST_ITEM_SELECTED()"
	^self geosMessage: #[108 1 2 0 0]!

!

!LogControl comment!
Library contlog, file contlog.goh! !

!LogControl class methodsFor: 'library linkage'!

library
	^17!

entry
	^4!
!

!LogControl methodsFor: 'Geos instance variables'!

!

!LogControl methodsFor: 'Geos vardata'!

attrLogControlNotifyEntrySelectedMsg: value
	"@vardata Message ATTR_LOG_CONTROL_NOTIFY_ENTRY_SELECTED_MSG"
	^self addVardata: ##attrLogControlNotifyEntrySelectedMsg word: value!

!

!LogControl methodsFor: 'Geos messages'!

controlAffirmDelete
	"@message void MSG_LOG_CONTROL_AFFIRM_DELETE()"
	^self geosMessage: #[110 0 2 0 0]!

controlDisplayLog
	"@message void MSG_LOG_CONTROL_DISPLAY_LOG()"
	^self geosMessage: #[110 1 2 0 0]!

controlViewEventsSearchSubset
	"@message void MSG_LOG_CONTROL_VIEW_EVENTS_SEARCH_SUBSET()"
	^self geosMessage: #[110 2 2 0 0]!

controlTrimLog
	"@message void MSG_LOG_CONTROL_TRIM_LOG()"
	^self geosMessage: #[110 3 2 0 0]!

controlSelectionChanged: selection
	"@message void MSG_LOG_CONTROL_SELECTION_CHANGED(int selection = cx)"
	^self geosMessage: #[110 4 2 5 4 0] with: selection!

controlSelectCurrentEntry
	"@message void MSG_LOG_CONTROL_SELECT_CURRENT_ENTRY()"
	^self geosMessage: #[110 5 2 0 0]!

!

!PersonContactsControl comment!
Library contlog, file contlog.goh! !

!PersonContactsControl class methodsFor: 'library linkage'!

library
	^17!

entry
	^2!
!

!PersonContactsControl methodsFor: 'Geos instance variables'!

pcciCurrentContactID
	"@instance dword PCCI_currentContactID"
	^self dwordAt: 39!

pcciCurrentContactID: value
	"@instance dword PCCI_currentContactID"
	^self dwordAt: 39 put: value!

!

!PersonContactsControl methodsFor: 'Geos vardata'!

!

!PersonContactsControl methodsFor: 'Geos messages'!

contactsControlDisplayLog: recID
	"@message void MSG_PERSON_CONTACTS_CONTROL_DISPLAY_LOG(dword recID = dx:cx)"
	^self geosMessage: #[110 0 2 46 2 0] with: recID!

contactsControlPersonContactsSearchSubset
	"@message void MSG_PERSON_CONTACTS_CONTROL_PERSON_CONTACTS_SEARCH_SUBSET()"
	^self geosMessage: #[110 1 2 0 0]!

contactsControlPersonContactsAffirmDelete
	"@message void MSG_PERSON_CONTACTS_CONTROL_PERSON_CONTACTS_AFFIRM_DELETE()"
	^self geosMessage: #[110 2 2 0 0]!

!

!RecentContactsControl comment!
Library contlog, file contlog.goh! !

!RecentContactsControl class methodsFor: 'library linkage'!

library
	^17!

entry
	^5!
!

!RecentContactsControl methodsFor: 'Geos instance variables'!

rcciListGroupOffset
	"@instance word RCCI_listGroupOffset"
	^self wordAt: 39!

rcciListGroupOffset: value
	"@instance word RCCI_listGroupOffset"
	^self wordAt: 39 put: value!

!

!RecentContactsControl methodsFor: 'Geos vardata'!

attrRecentContactsControlNotifyEntrySelectedMsg: value
	"@vardata Message ATTR_RECENT_CONTACTS_CONTROL_NOTIFY_ENTRY_SELECTED_MSG"
	^self addVardata: ##attrRecentContactsControlNotifyEntrySelectedMsg word: value!

tempRecentContactsControlConfirmDialog: value
	"@vardata optr TEMP_RECENT_CONTACTS_CONTROL_CONFIRM_DIALOG"
	^self addVardata: ##tempRecentContactsControlConfirmDialog dword: value!

attrRecentContactsControlNotifyMultipleEntriesSelectedMsg: value
	"@vardata Message ATTR_RECENT_CONTACTS_CONTROL_NOTIFY_MULTIPLE_ENTRIES_SELECTED_MSG"
	^self addVardata: ##attrRecentContactsControlNotifyMultipleEntriesSelectedMsg word: value!

!

!RecentContactsControl methodsFor: 'Geos messages'!

contactsControlRetrieveList: rct
	"@message void MSG_RECENT_CONTACTS_CONTROL_RETRIEVE_LIST( RecentContactsType rct = cx)"
	^self geosMessage: #[110 0 2 5 1 0] with: rct!

contactsControlOpenList
	"@message void MSG_RECENT_CONTACTS_CONTROL_OPEN_LIST()"
	^self geosMessage: #[110 1 2 0 0]!

contactsControlListQuery
	"@message void MSG_RECENT_CONTACTS_CONTROL_LIST_QUERY()"
	^self geosMessage: #[110 2 2 0 0]!

contactsControlClearAll
	"@message void MSG_RECENT_CONTACTS_CONTROL_CLEAR_ALL()"
	^self geosMessage: #[110 3 2 0 0]!

contactsControlSelectCurrentEntry
	"@message void MSG_RECENT_CONTACTS_CONTROL_SELECT_CURRENT_ENTRY()"
	^self geosMessage: #[110 4 2 0 0]!

contactsControlEraseStack
	"@message void MSG_RECENT_CONTACTS_CONTROL_ERASE_STACK()"
	^self geosMessage: #[110 5 2 0 0]!

contactsControlEraseStackCanceled
	"@message void MSG_RECENT_CONTACTS_CONTROL_ERASE_STACK_CANCELED()"
	^self geosMessage: #[110 6 2 0 0]!

contactsControlCopyNumber
	"@message void MSG_RECENT_CONTACTS_CONTROL_COPY_NUMBER()"
	^self geosMessage: #[110 7 2 0 0]!

contactsControlClearAllLists
	"@message void MSG_RECENT_CONTACTS_CONTROL_CLEAR_ALL_LISTS()"
	^self geosMessage: #[110 8 2 0 0]!

contactsControlClearAllListsOk
	"@message void MSG_RECENT_CONTACTS_CONTROL_CLEAR_ALL_LISTS_OK()"
	^self geosMessage: #[110 9 2 0 0]!

contactsControlSelectionChanged
	"@message void MSG_RECENT_CONTACTS_CONTROL_SELECTION_CHANGED()"
	^self geosMessage: #[110 10 2 0 0]!

contactsControlOpenGivenList: rct
	"@message void MSG_RECENT_CONTACTS_CONTROL_OPEN_GIVEN_LIST(RecentContactsType rct = cx)"
	^self geosMessage: #[110 11 2 5 1 0] with: rct!

contactsControlCreateCard: logGenDynamicList with: contactTemplateEditor with: contactTemplateEditorBox
	"@message void MSG_RECENT_CONTACTS_CONTROL_CREATE_CARD( ChunkHandle logGenDynamicList = cx, ChunkHandle contactTemplateEditor = dx, ChunkHandle contactTemplateEditorBox = bp)"
	^self geosMessage: #[110 12 3 245 1 1 1 0] with: logGenDynamicList with: contactTemplateEditor with: contactTemplateEditorBox!

!

!RecentContactsFaxControl comment!
Library contlog, file contlog.goh! !

!RecentContactsFaxControl class methodsFor: 'library linkage'!

library
	^17!

entry
	^7!
!

!RecentContactsFaxControl methodsFor: 'Geos instance variables'!

!

!RecentContactsFaxControl methodsFor: 'Geos vardata'!

!

!RecentContactsFaxControl methodsFor: 'Geos messages'!

!

!RecentContactsPhoneControl comment!
Library contlog, file contlog.goh! !

!RecentContactsPhoneControl class methodsFor: 'library linkage'!

library
	^17!

entry
	^6!
!

!RecentContactsPhoneControl methodsFor: 'Geos instance variables'!

!

!RecentContactsPhoneControl methodsFor: 'Geos vardata'!

attrRecentContactsPhoneControlNotifyMissedCallsListOpenedMsg: value
	"@vardata Message ATTR_RECENT_CONTACTS_PHONE_CONTROL_NOTIFY_MISSED_CALLS_LIST_OPENED_MSG"
	^self addVardata: ##attrRecentContactsPhoneControlNotifyMissedCallsListOpenedMsg word: value!

!

!RecentContactsPhoneControl methodsFor: 'Geos messages'!

!

!RecentContactsSMSControl comment!
Library contlog, file contlog.goh! !

!RecentContactsSMSControl class methodsFor: 'library linkage'!

library
	^17!

entry
	^8!
!

!RecentContactsSMSControl methodsFor: 'Geos instance variables'!

!

!RecentContactsSMSControl methodsFor: 'Geos vardata'!

!

!RecentContactsSMSControl methodsFor: 'Geos messages'!

!

